VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "cOuterBorders"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private RectSegments As cpSegmentShapeCollection, TextPath As cCairoPath

Public Sub Construct(ByVal X As Double, ByVal Y As Double, ByVal Width As Double, ByVal Height As Double, Optional ByVal Thickness = 2)
Dim TextSegments As cpSegmentShapeCollection, S As cpSegmentShape
  
  With PhEngine.ConstructionCC
    'this just demonstrates a handy feature of the Wrapper, you can basically use any
    'Cairo-CC-drawing-routine, to construct your chipmunk-shapes ... here we use a simple Rectangle-Call
    .Rectangle X, Y, Width, Height
    
    'Note, that we do *not* do any .Fill or .Stroke within here, we just need to feed the
    'Method below with the current Cairo-Path-Segments, which we retrieve per .CopyPath(True)
    Set RectSegments = PhEngine.StaticBody.CreateSegmentShapeCollectionFromPath(.CopyPath(True), Thickness)
    
    
    'now the same thing again, with a more complex path (a TextOut-Path, just to demonstrate, that this works too)
    .ClearPath
    .Save
      .ScaleDrawings 1, -1 'flip the TextOut in y-Direction
      .SelectFont "Arial", 16
      .TextOut 70, -16, "...easy construction of complex chipmunk-shapes using cairo-paths...", True, , True
    .Restore
    Set TextPath = .CopyPath(True, 0.5)
    Set TextSegments = PhEngine.StaticBody.CreateSegmentShapeCollectionFromPath(TextPath, 1)
  End With

  For Each S In RectSegments
    PhEngine.Space.AddStaticShape S, 0.2, 0.95 'here we iterate through the just added Shapes and add them statically to our Space
  Next S
  For Each S In TextSegments
    PhEngine.Space.AddStaticShape S, 0.2, 0.95 'here we iterate through the just added Shapes and add them statically to our Space
  Next S
End Sub

Public Sub Draw(CC As cCairoContext)
Dim S As cpSegmentShape
Static TextCachePat As cCairoPattern

  CC.Save
  
    CC.SetLineCap CAIRO_LINE_CAP_SQUARE
    
    For Each S In RectSegments
      CC.DrawLine S.A_X, S.A_Y, S.B_X, S.B_Y
    Next S
      CC.SetLineWidth RectSegments.Thickness
      CC.SetSourceColor vbGreen
    CC.Stroke
    
    If TextCachePat Is Nothing Then '<- the text-rendering into this Pattern is done only once
      CC.PushGroup CAIRO_CONTENT_COLOR_ALPHA, 0, 0, 800, 40 'we use the optional Clipping-Params of this call, to save some memory
        CC.AppendPath TextPath
        CC.Fill
      Set TextCachePat = CC.PopGroup(True) 'and here the optional Param needs to be present now too, to reset the Clipping
    End If
    CC.SetSourcePattern TextCachePat '...since the above is only done once, we can now reuse the cached Textout over the Pattern
    CC.Paint
    
  CC.Restore
End Sub

